function output=fvdelayfit(time,data)

%This fits a single exponential to the fluorescence data. It is called by
%fluorescencewrapper

%--------------------------------------------------------------------------
% Declare exclusion region for pulse fit and baseline region
fitExclusion=[1:4];
%--------------------------------------------------------------------------
%close all;
%declare fit function to use
fitfunc=fittype('a*exp(-x/b)+c');
options=fitoptions(fitfunc);
%%%%%Set options here for the exponential fit (constraints, number of times to evaluate it, tolerance of difference between evaluations)%%%%
%This can be unhardcoded as well
options=fitoptions(options,'Lower',[-Inf,0,-Inf],'MaxFunEvals',6000,'TolFun',1e-12);

%fit bleaching curves and subtract from data; normalize resulting data
fittaus=zeros(1,size(data,2));
fitzeros=zeros(1,size(data,2));
for n=1:size(data,2)
    %Provide data to exclude from fitting based on fitExclusion above (this
    %can be unhardcoded)
    exclusions=excludedata(time,data(:,n),'indices',fitExclusion);
    options=fitoptions(options,'Exclude',exclusions,'StartPoint',[-mean(data(:,n)),mean(time),data(end,n)]);
    %Fit exponential to data
    zerofit=fit(time,data(:,n),fitfunc,options);
    %Pull out coefficient values of the exponential fit to the data
    coeffs=coeffvalues(zerofit);
    a=coeffs(1);
    tau=coeffs(2);
    c=coeffs(3);
    %Assign time constant to array fittaus
    fittaus(n)=tau;
    %Plot fit to each figure
    figure;
    plot(zerofit,time,data(:,n));
    %Code below can be uncommented to fit the delay prior to fluorescence
    %onset
         if(a*c>0)
             disp(['Curve ' num2str(n) ' fit error; curve does not cross 0.']);
             fitzeros(n)=NaN;
             continue;
         end
         fitzeros(n)=-tau*log(-c/a);
end
output=[fitzeros',fittaus'];